/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel.valid.handler;

import cn.gjing.excel.base.context.ExcelWriterContext;
import cn.gjing.excel.valid.handler.CascadeBoxAnnotationHandler;
import cn.gjing.excel.valid.handler.CustomMacroAnnotationHandler;
import cn.gjing.excel.valid.handler.DateAnnotationHandler;
import cn.gjing.excel.valid.handler.DropdownAnnotationHandler;
import cn.gjing.excel.valid.handler.NumericAnnotationHandler;
import cn.gjing.excel.valid.handler.RepeatAnnotationHandler;
import cn.gjing.excel.valid.handler.ValidAnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;

public enum HandleMeta {
    INSTANCE;

    private final List<ValidAnnotationHandler> handlers = new ArrayList<ValidAnnotationHandler>();

    private HandleMeta() {
        this.handlers.add(new DropdownAnnotationHandler());
        this.handlers.add(new NumericAnnotationHandler());
        this.handlers.add(new RepeatAnnotationHandler());
        this.handlers.add(new DateAnnotationHandler());
        this.handlers.add(new CascadeBoxAnnotationHandler());
        this.handlers.add(new CustomMacroAnnotationHandler());
    }

    public void exec(Field field, ExcelWriterContext writerContext, Row row, int colIndex, Map<String, String[]> boxValues, Map<String, String[]> cascadeValues) {
        for (ValidAnnotationHandler handler : this.handlers) {
            Annotation annotation = field.getAnnotation(handler.getAnnotationClass());
            if (annotation == null) continue;
            handler.handle(annotation, writerContext, field, row, colIndex, boxValues, cascadeValues);
            break;
        }
    }
}

