/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel.valid.handler;

import cn.gjing.excel.base.context.ExcelWriterContext;
import cn.gjing.excel.base.exception.ExcelException;
import cn.gjing.excel.base.util.ExcelUtils;
import cn.gjing.excel.valid.ExcelCascadeBox;
import cn.gjing.excel.valid.ValidUtil;
import cn.gjing.excel.valid.handler.ValidAnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;

public class CascadeBoxAnnotationHandler
extends ValidAnnotationHandler {
    public CascadeBoxAnnotationHandler() {
        super(ExcelCascadeBox.class);
    }

    @Override
    public void handle(Annotation validAnnotation, ExcelWriterContext writerContext, Field field, Row row, int colIndex, Map<String, String[]> boxValues, Map<String, String[]> cascadeValues) {
        if (writerContext.getWorkbook().getSheet("subsetSheet") == null) {
            if (cascadeValues == null || cascadeValues.isEmpty()) {
                throw new ExcelException("The cascading drop-down box options cannot be left blank");
            }
            Sheet explicitSheet = writerContext.getWorkbook().createSheet("subsetSheet");
            writerContext.getWorkbook().setSheetHidden(writerContext.getWorkbook().getSheetIndex("subsetSheet"), true);
            for (Map.Entry<String, String[]> valueMap : cascadeValues.entrySet()) {
                Name name = writerContext.getWorkbook().getName(valueMap.getKey());
                if (name != null) continue;
                int rowIndex = explicitSheet.getPhysicalNumberOfRows();
                Row subsetSheetRow = explicitSheet.createRow(rowIndex);
                subsetSheetRow.createCell(0).setCellValue(valueMap.getKey());
                int length = valueMap.getValue().length;
                for (int i = 0; i < length; ++i) {
                    subsetSheetRow.createCell(i + 1).setCellValue(valueMap.getValue()[i]);
                }
                String formula = ExcelUtils.createFormulaX((int)1, (int)(rowIndex + 1), (int)valueMap.getValue().length);
                name = writerContext.getWorkbook().createName();
                name.setNameName(valueMap.getKey());
                name.setRefersToFormula("subsetSheet!" + formula);
            }
        }
        ExcelCascadeBox cascadeBox = (ExcelCascadeBox)validAnnotation;
        char parentIndex = (char)(65 + Integer.parseInt(cascadeBox.link()));
        DataValidationHelper helper = writerContext.getSheet().getDataValidationHelper();
        int firstRow = row.getRowNum() + 1;
        int lastRow = cascadeBox.rows() == 0 ? firstRow : cascadeBox.rows() + firstRow - 1;
        for (int i = firstRow; i <= lastRow; ++i) {
            String forMuaString = "INDIRECT($" + parentIndex + "$" + (i + 1) + ")";
            DataValidationConstraint constraint = helper.createFormulaListConstraint(forMuaString);
            CellRangeAddressList regions = new CellRangeAddressList(i, i, colIndex, colIndex);
            DataValidation dataValidation = helper.createValidation(constraint, regions);
            ValidUtil.setErrorBox(dataValidation, cascadeBox.error(), cascadeBox.rank(), cascadeBox.errTitle(), cascadeBox.errMsg(), cascadeBox.prompt(), cascadeBox.pTitle(), cascadeBox.pMsg());
            writerContext.getSheet().addValidationData(dataValidation);
        }
    }
}

