/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel.base.util;

import cn.gjing.excel.base.meta.ExcelType;
import cn.gjing.excel.base.util.ParamUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public final class ExcelUtils {
    public static void setCellValue(Cell cell, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            cell.setCellValue(value.toString());
            return;
        }
        if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
            return;
        }
        if (value instanceof Enum) {
            cell.setCellValue(value.toString());
            return;
        }
        if (value instanceof Date) {
            cell.setCellValue((Date)value);
            return;
        }
        if (value instanceof LocalDateTime) {
            cell.setCellValue((LocalDateTime)value);
            return;
        }
        if (value instanceof LocalDate) {
            cell.setCellValue((LocalDate)value);
            return;
        }
        throw new IllegalArgumentException("Unsupported data type, you can use a data converter " + value);
    }

    public static ExcelType getExcelType(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(".") + 1;
        String extension = fileName.substring(pos);
        if ("xls".equals(extension)) {
            return ExcelType.XLS;
        }
        if ("xlsx".equals(extension)) {
            return ExcelType.XLSX;
        }
        return null;
    }

    public static void merge(Sheet sheet, int firstCol, int lastCol, int firstRow, int LastRow) {
        sheet.addMergedRegionUnsafe(new CellRangeAddress(firstRow, LastRow, firstCol, lastCol));
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, int index) {
        return sheet.getMergedRegion(index);
    }

    public static String createSumFormula(int firstColIndex, int firstRowIndex, int lastColIndex, int lastRowIndex) {
        return ExcelUtils.createFormula("SUM", firstColIndex, firstRowIndex, lastColIndex, lastRowIndex);
    }

    public static String createFormula(String suffix, int firstColIndex, int firstRowIndex, int lastColIndex, int lastRowIndex) {
        if (firstRowIndex == lastRowIndex) {
            return suffix + "(" + ExcelUtils.createFormulaX(firstColIndex, firstRowIndex, lastColIndex) + ")";
        }
        if (firstColIndex == lastColIndex) {
            return suffix + "(" + ExcelUtils.createFormulaY(firstColIndex, firstRowIndex, lastRowIndex) + ")";
        }
        throw new IllegalArgumentException();
    }

    public static Font createFont(Workbook workbook) {
        return workbook.createFont();
    }

    public static RichTextString createRichText(Workbook workbook, String content) {
        return workbook.getCreationHelper().createRichTextString(content);
    }

    public static Hyperlink createLink(Workbook workbook, HyperlinkType type) {
        return workbook.getCreationHelper().createHyperlink(type);
    }

    public static boolean isMerge(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public static String createFormulaX(int startColIndex, int rowIndex, int endColIndex) {
        char endSuffix;
        char start = (char)(65 + startColIndex);
        if (endColIndex <= 25) {
            if (endColIndex == 0) {
                return "$" + start + "$" + rowIndex;
            }
            char end = (char)(start + endColIndex - 1);
            return "$" + start + "$" + rowIndex + ":$" + end + "$" + rowIndex;
        }
        char endPrefix = 'A';
        if ((endColIndex - 25) % 26 == 0) {
            endSuffix = 'Z';
            endPrefix = (char)(endPrefix + (endColIndex - 25) / 26 - 1);
        } else {
            endSuffix = (char)(65 + (endColIndex - 25) % 26 - 1);
            endPrefix = (char)(endPrefix + (endColIndex - 25) / 26);
        }
        return "$" + start + "$" + rowIndex + ":$" + endPrefix + endSuffix + "$" + rowIndex;
    }

    public static String createFormulaY(int colIndex, int startRow, int endRow) {
        if (colIndex < 26) {
            return "$" + (char)(65 + colIndex) + "$" + startRow + ":$" + (char)(65 + colIndex) + "$" + endRow;
        }
        String all = ParamUtils.numberToEn(colIndex);
        return "$" + all + "$" + startRow + ":$" + all + "$" + endRow;
    }
}

