/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel.base.util;

import cn.gjing.excel.base.ExcelFieldProperty;
import cn.gjing.excel.base.annotation.ExcelField;
import cn.gjing.excel.base.util.ParamUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class BeanUtils {
    public static void setFieldValue(Object o, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object o, Field field) {
        try {
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static List<ExcelFieldProperty> getExcelFiledProperties(Class<?> excelClass, String[] ignores) {
        ArrayList<ExcelFieldProperty> fieldProperties = new ArrayList<ExcelFieldProperty>();
        BeanUtils.getAllFields(excelClass).stream().filter(e -> e.isAnnotationPresent(ExcelField.class)).sorted(Comparator.comparing(e -> e.getAnnotation(ExcelField.class).order())).forEach(e -> {
            String[] headNameArray;
            ExcelField excelField = e.getAnnotation(ExcelField.class);
            for (String name : headNameArray = excelField.value()) {
                if (!ParamUtils.contains(ignores, name)) continue;
                return;
            }
            fieldProperties.add(ExcelFieldProperty.builder().value(excelField.value()).field((Field)e).title(excelField.title()).width(excelField.width()).order(fieldProperties.size()).format(excelField.format()).color(excelField.color()).fontColor(excelField.fontColor()).build());
        });
        return fieldProperties;
    }

    public static Map<String, Field> getExcelFieldsMap(Class<?> excelClass) {
        List<Field> fieldList = BeanUtils.getAllFields(excelClass);
        return fieldList.stream().filter(e -> e.isAnnotationPresent(ExcelField.class)).collect(Collectors.toMap(e -> {
            ExcelField excelField = e.getAnnotation(ExcelField.class);
            String[] headArray = excelField.value();
            return headArray[headArray.length - 1] + excelField.title();
        }, f -> f));
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(declaredFields));
        for (Class<?> superclass = clazz.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(superclass.getDeclaredFields()));
        }
        return fieldList;
    }
}

