/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.excel.base.util;

import cn.gjing.excel.base.BigTitle;
import cn.gjing.excel.base.ExcelFieldProperty;
import cn.gjing.excel.base.listener.ExcelListener;
import cn.gjing.excel.base.listener.read.ExcelEmptyReadListener;
import cn.gjing.excel.base.listener.read.ExcelRowReadListener;
import cn.gjing.excel.base.listener.write.ExcelCellWriteListener;
import cn.gjing.excel.base.listener.write.ExcelRowWriteListener;
import cn.gjing.excel.base.listener.write.ExcelSheetWriteListener;
import cn.gjing.excel.base.listener.write.ExcelStyleWriteListener;
import cn.gjing.excel.base.listener.write.ExcelWorkbookWriteListener;
import cn.gjing.excel.base.meta.RowType;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public final class ListenerChain {
    public static void doCompleteCell(List<ExcelListener> listeners, Sheet sheet, Row row, Cell cell, ExcelFieldProperty property, int index, int colIndex, RowType rowType) {
        if (listeners != null) {
            for (ExcelListener cellListener : listeners) {
                if (!(cellListener instanceof ExcelCellWriteListener)) continue;
                ((ExcelCellWriteListener)cellListener).completeCell(sheet, row, cell, property, index, colIndex, rowType);
            }
        }
    }

    public static Object doAssignmentBefore(List<ExcelListener> listeners, Sheet sheet, Row row, Cell cell, ExcelFieldProperty property, int index, int colIndex, RowType rowType, Object value) {
        Object val = value;
        if (listeners != null) {
            for (ExcelListener cellListener : listeners) {
                if (!(cellListener instanceof ExcelCellWriteListener)) continue;
                val = ((ExcelCellWriteListener)cellListener).assignmentBefore(sheet, row, cell, property, index, colIndex, rowType, val);
            }
        }
        return val;
    }

    public static void doCreateRowBefore(List<ExcelListener> listeners, Sheet sheet, int index, RowType rowType) {
        if (listeners != null) {
            for (ExcelListener rowListener : listeners) {
                if (!(rowListener instanceof ExcelRowWriteListener)) continue;
                ((ExcelRowWriteListener)rowListener).createBefore(sheet, index, rowType);
            }
        }
    }

    public static void doCompleteRow(List<ExcelListener> listeners, Sheet sheet, Row row, Object obj, int index, RowType rowType) {
        if (listeners != null) {
            for (ExcelListener rowListener : listeners) {
                if (!(rowListener instanceof ExcelRowWriteListener)) continue;
                ((ExcelRowWriteListener)rowListener).completeRow(sheet, row, obj, index, rowType);
            }
        }
    }

    public static void doCompleteSheet(List<ExcelListener> listeners, Sheet sheet) {
        if (listeners != null) {
            for (ExcelListener sheetListener : listeners) {
                if (!(sheetListener instanceof ExcelSheetWriteListener)) continue;
                ((ExcelSheetWriteListener)sheetListener).completeSheet(sheet);
            }
        }
    }

    public static boolean doWorkbookFlushBefore(List<ExcelListener> workbookListeners, Workbook workbook) {
        boolean continueDownload = true;
        if (workbookListeners != null) {
            for (ExcelListener workbookListener : workbookListeners) {
                if (!(workbookListener instanceof ExcelWorkbookWriteListener)) continue;
                continueDownload = ((ExcelWorkbookWriteListener)workbookListener).flushBefore(workbook);
            }
        }
        return continueDownload;
    }

    public static void doSetTitleStyle(List<ExcelListener> styleListeners, BigTitle bigTitle, Cell cell) {
        if (styleListeners != null) {
            for (ExcelListener styleListener : styleListeners) {
                if (!(styleListener instanceof ExcelStyleWriteListener)) continue;
                ((ExcelStyleWriteListener)styleListener).setTitleStyle(bigTitle, cell);
            }
        }
    }

    public static void doSetHeadStyle(List<ExcelListener> styleListeners, Row row, Cell cell, ExcelFieldProperty property, int index, int colIndex) {
        if (styleListeners != null) {
            for (ExcelListener styleListener : styleListeners) {
                if (!(styleListener instanceof ExcelStyleWriteListener)) continue;
                ((ExcelStyleWriteListener)styleListener).setHeadStyle(row, cell, property, index, colIndex);
            }
        }
    }

    public static void doSetBodyStyle(List<ExcelListener> styleListeners, Row row, Cell cell, ExcelFieldProperty property, int index, int colIndex) {
        if (styleListeners != null) {
            for (ExcelListener styleListener : styleListeners) {
                if (!(styleListener instanceof ExcelStyleWriteListener)) continue;
                ((ExcelStyleWriteListener)styleListener).setBodyStyle(row, cell, property, index, colIndex);
            }
        }
    }

    public static <R> boolean doReadRow(List<ExcelListener> rowReadListeners, R r, Row row, RowType rowType) {
        boolean continueRead = true;
        if (rowReadListeners != null) {
            for (ExcelListener rowReadListener : rowReadListeners) {
                if (!(rowReadListener instanceof ExcelRowReadListener)) continue;
                ((ExcelRowReadListener)rowReadListener).readRow(r, row, row.getRowNum(), rowType);
                continueRead = ((ExcelRowReadListener)rowReadListener).continueRead();
            }
        }
        return continueRead;
    }

    public static <R> void doReadBefore(List<ExcelListener> listeners) {
        if (listeners != null) {
            for (ExcelListener listener : listeners) {
                if (!(listener instanceof ExcelRowReadListener)) continue;
                ((ExcelRowReadListener)listener).readBefore();
            }
        }
    }

    public static Object doReadCell(List<ExcelListener> rowReadListeners, Object cellValue, Cell cell, int rowIndex, int colIndex, RowType rowType) {
        Object val = cellValue;
        if (rowReadListeners != null) {
            for (ExcelListener rowReadListener : rowReadListeners) {
                if (!(rowReadListener instanceof ExcelRowReadListener)) continue;
                val = ((ExcelRowReadListener)rowReadListener).readCell(val, cell, rowIndex, colIndex, rowType);
            }
        }
        return val;
    }

    public static <R> void doReadFinish(List<ExcelListener> rowReadListeners) {
        if (rowReadListeners != null) {
            for (ExcelListener rowReadListener : rowReadListeners) {
                if (!(rowReadListener instanceof ExcelRowReadListener)) continue;
                ((ExcelRowReadListener)rowReadListener).readFinish();
            }
        }
    }

    public static <R> boolean doReadEmpty(List<ExcelListener> emptyReadListeners, R r, int rowIndex, int colIndex) {
        boolean isSave = false;
        if (emptyReadListeners != null) {
            for (ExcelListener emptyReadListener : emptyReadListeners) {
                if (!(emptyReadListener instanceof ExcelEmptyReadListener)) continue;
                isSave = ((ExcelEmptyReadListener)emptyReadListener).readEmpty(r, rowIndex, colIndex);
            }
        }
        return isSave;
    }
}

