/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import cn.gjing.OssModel;
import cn.gjing.ParamUtil;
import cn.gjing.TimeUtil;
import cn.gjing.annotation.NotNull2;
import cn.gjing.enums.HttpStatus;
import cn.gjing.ex.ParamException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliOss {
    private static OSSClient instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OSSClient getOssClient(OssModel ossModel) {
        if (instance != null) return instance;
        Class<AliOss> clazz = AliOss.class;
        synchronized (AliOss.class) {
            if (instance != null) return instance;
            instance = new OSSClient(ossModel.getEndPoint(), ossModel.getAccessKeyId(), ossModel.getAccessKeySecret());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static void createBucket(OssModel ossModel) {
        try {
            if (!AliOss.getOssClient(ossModel).doesBucketExist(ossModel.getBucketName())) {
                AliOss.getOssClient(ossModel).createBucket(ossModel.getBucketName());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("\u521b\u5efaBucket\u5931\u8d25,\u8bf7\u6838\u5bf9Bucket\u540d\u79f0(\u89c4\u5219\uff1a\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u77ed\u6a2a\u7ebf\uff0c\u5fc5\u987b\u4ee5\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u5f00\u5934\u548c\u7ed3\u5c3e\uff0c\u957f\u5ea6\u57283-63\u4e4b\u95f4)");
        }
    }

    private static String getContentType(String fileName) {
        String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if ("bmp".equalsIgnoreCase(fileExtension)) {
            return "image/bmp";
        }
        if ("gif".equalsIgnoreCase(fileExtension)) {
            return "image/gif";
        }
        if ("jpeg".equalsIgnoreCase(fileExtension) || "jpg".equalsIgnoreCase(fileExtension)) {
            return "image/jpeg";
        }
        if ("png".equalsIgnoreCase(fileExtension)) {
            return "image/png";
        }
        if ("html".equalsIgnoreCase(fileExtension)) {
            return "text/html";
        }
        if ("txt".equalsIgnoreCase(fileExtension)) {
            return "text/plain";
        }
        if ("vsd".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.visio";
        }
        if ("ppt".equalsIgnoreCase(fileExtension) || "pptx".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if ("doc".equalsIgnoreCase(fileExtension) || "docx".equalsIgnoreCase(fileExtension)) {
            return "application/msword";
        }
        if ("xml".equalsIgnoreCase(fileExtension)) {
            return "text/xml";
        }
        return "text/html";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String uploadFile(MultipartFile file, OssModel ossModel) {
        String fileName = String.format("%s.%s", UUID.randomUUID().toString(), FilenameUtils.getExtension((String)file.getOriginalFilename()));
        try (InputStream inputStream = file.getInputStream();){
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(FilenameUtils.getExtension((String)("." + file.getOriginalFilename())));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            AliOss.getOssClient(ossModel).putObject(ossModel.getBucketName(), fileName, inputStream, objectMetadata);
            String string = fileName;
            return string;
        }
        catch (Exception oe) {
            throw new IllegalStateException(oe.getMessage());
        }
    }

    private static String getFileUrl(String fileUrl, OssModel ossModel) {
        if (ParamUtil.isEmpty((Object)fileUrl)) {
            throw new ParamException("The parameter fileUrl cannot be null!");
        }
        String[] split = ParamUtil.split((String)fileUrl, (String)"/");
        if (ParamUtil.isEmpty((Object)split)) {
            throw new ParamException(HttpStatus.INVALID_PARAMETER.getMsg());
        }
        URL url = AliOss.getOssClient(ossModel).generatePresignedUrl(ossModel.getBucketName(), split[split.length - 1], TimeUtil.addDay((Date)new Date(), (int)3650));
        if (url == null) {
            throw new IllegalStateException("get oss file url error");
        }
        return url.toString();
    }

    private static String getPathUrl(String fileOssUrl, OssModel ossModel) {
        return fileOssUrl.substring(fileOssUrl.indexOf(ossModel.getEndPoint()) + ossModel.getEndPoint().length() + 1);
    }

    @NotNull2
    public static boolean delete(List<String> fileOssUrls, OssModel ossModel) {
        List urlList = fileOssUrls.stream().map(e -> AliOss.getPathUrl(e, ossModel)).collect(Collectors.toList());
        try {
            AliOss.getOssClient(ossModel).deleteObjects(new DeleteObjectsRequest(ossModel.getBucketName()).withKeys(urlList));
            return true;
        }
        catch (RuntimeException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    @NotNull2
    public static String upload(MultipartFile file, OssModel ossModel) {
        if (file.getSize() > 0x40000000L) {
            throw new ParamException("Upload failed. file size cannot more than 5 gb");
        }
        AliOss.createBucket(ossModel);
        String fileName = AliOss.uploadFile(file, ossModel);
        String fileOssUrl = AliOss.getFileUrl(fileName, ossModel);
        int firstChar = fileOssUrl.indexOf("?");
        if (firstChar > 0) {
            fileOssUrl = fileOssUrl.substring(0, firstChar);
        }
        return fileOssUrl;
    }

    @NotNull2
    public static boolean downloadFile(OssModel ossModel, String fileOssUrl, String mkdir) {
        try {
            if (ParamUtil.isNotEmpty((Object)mkdir)) {
                File file = new File(mkdir);
                if (!file.exists() && !file.mkdir()) {
                    throw new IllegalStateException("create file exception");
                }
                OSSClient ossClient = AliOss.getOssClient(ossModel);
                Predicate<String> predicate = e -> e.indexOf("/", e.length() - 1) != -1;
                String pathUrl = AliOss.getPathUrl(fileOssUrl, ossModel);
                ossClient.getObject(new GetObjectRequest(ossModel.getBucketName(), pathUrl), new File(predicate.test(mkdir) ? mkdir + pathUrl : mkdir + "/" + pathUrl));
                return true;
            }
            throw new ParamException("mkdir cannot be null");
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    @NotNull2
    public static boolean downloadStream(OssModel ossModel, String fileOssUrl, HttpServletResponse response) {
        try {
            int len;
            String pathUrl = AliOss.getPathUrl(fileOssUrl, ossModel);
            OSSObject object = AliOss.getOssClient(ossModel).getObject(ossModel.getBucketName(), pathUrl);
            InputStream is = object.getObjectContent();
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(AliOss.getPathUrl(fileOssUrl, ossModel), "UTF-8"));
            response.setContentLength((int)object.getObjectMetadata().getContentLength());
            byte[] b = new byte[1024];
            while (-1 != (len = is.read(b))) {
                ((OutputStream)os).write(b, 0, len);
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        return true;
    }
}

