/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.resources.core.entity;

import cn.geminis.resources.core.entity.AbstractEntity;
import cn.geminis.resources.core.entity.OrgData;
import cn.geminis.resources.core.entity.OrgProperty;
import cn.geminis.resources.core.entity.OrgUser;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.Transient;
import org.springframework.util.StringUtils;

@Entity
public class Organization
extends AbstractEntity<OrgProperty, OrgData> {
    @Column(nullable=false)
    private String pathId;
    @Column(length=36)
    private String parentId;
    @Column(nullable=false, length=36)
    private String type;
    @Column(nullable=false)
    private int showOrder;
    @OneToMany(mappedBy="organization", cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE})
    private Set<OrgUser> users;
    @Transient
    @JsonProperty
    private String parentPath;

    @PrePersist
    void setPathId() {
        if (StringUtils.isEmpty((Object)this.parentPath)) {
            throw new RuntimeException("\u9700\u8981\u8bbe\u7f6e\u4e0a\u7ea7ID\u8def\u5f84");
        }
        this.pathId = this.parentPath + this.getId() + "/";
    }

    public String getPathId() {
        return this.pathId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getType() {
        return this.type;
    }

    public int getShowOrder() {
        return this.showOrder;
    }

    public Set<OrgUser> getUsers() {
        return this.users;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setShowOrder(int showOrder) {
        this.showOrder = showOrder;
    }

    public void setUsers(Set<OrgUser> users) {
        this.users = users;
    }

    @JsonProperty
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }
}

