/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.resources.core.entity;

import cn.geminis.resources.core.entity.AbstractEntityData;
import cn.geminis.resources.core.entity.AbstractEntityProperty;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;

@MappedSuperclass
public abstract class AbstractEntity<TProperty extends AbstractEntityProperty, TData extends AbstractEntityData> {
    @Id
    @Column(length=36)
    protected String id;
    @Column(nullable=false, length=128)
    protected String name;
    @OneToMany(mappedBy="entity", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private Set<TProperty> properties;
    @OneToMany(mappedBy="entity", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private Set<TData> data;

    @PrePersist
    void setId() {
        if (Objects.isNull(this.id)) {
            this.id = UUID.randomUUID().toString();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<TProperty> getProperties() {
        return this.properties;
    }

    public Set<TData> getData() {
        return this.data;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Set<TProperty> properties) {
        this.properties = properties;
    }

    public void setData(Set<TData> data) {
        this.data = data;
    }
}

