package cn.geminis.resources.core.entity;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Allen
 */
@Entity
@Getter
@Setter
public class User extends AbstractEntity<UserProperty, UserData> {

    @OneToMany(mappedBy = "user", cascade = {CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE})
    private Set<OrgUser> organizations = new HashSet<>();

    @ManyToMany(cascade = {CascadeType.MERGE})
    private Set<Role> roles = new HashSet<>();

}
