package cn.geminis.resources.core.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

/**
 * @author puddi
 */
@Entity
@Setter
@Getter
public class Role {

    @Id
    @Column(length = 36)
    private String id;

    @Column(nullable = false, length = 32)
    private String name;

    @ManyToMany(cascade = {CascadeType.MERGE})
    private Set<Function> functions = new HashSet<>();

    @ManyToMany(cascade = {CascadeType.MERGE})
    private Set<Role> rolesManage = new HashSet<>();

    @JsonBackReference
    public Set<Role> getRolesManage() {
        return rolesManage;
    }

    @PrePersist
    void createId() {
        if (StringUtils.isEmpty(this.id)) {
            this.id = UUID.randomUUID().toString();
        }
    }

}
