package cn.geminis.resources.core.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.util.Set;

/**
 * @author Allen
 */
@Entity
@Getter
@Setter
public class Organization extends AbstractEntity<OrgProperty, OrgData> {

    @Column(nullable = false)
    private String pathId;

    @Column(length = 36)
    private String parentId;

    @Column(nullable = false, length = 36)
    private String type;

    @Column(nullable = false)
    private int showOrder;

    @OneToMany(mappedBy = "organization", cascade = {CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE})
    private Set<OrgUser> users;

    @Transient
    @JsonProperty
    private String parentPath;

    @PrePersist
    void setPathId() {
        if (StringUtils.isEmpty(this.parentPath)) {
            throw new RuntimeException("需要设置上级ID路径");
        }
        this.pathId = this.parentPath + this.getId() + "/";
    }
}
