package cn.geminis.resources.core.entity;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.util.UUID;

/**
 * @author Allen
 */
@Entity
@Getter
@Setter
public class OrgUser implements Serializable {

    @Id
    @Column(length = 36)
    protected String id;

    @Column(nullable = false, length = 32)
    protected String type;

    @Column(nullable = false)
    private int showOrder;

    @ManyToOne
    protected Organization organization;

    @ManyToOne
    protected User user;

    @PrePersist
    void createId() {
        if (StringUtils.isEmpty(this.id)) {
            this.id = UUID.randomUUID().toString();
        }
    }

}
