package cn.geminis.resources.core.entity;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Objects;
import java.util.UUID;

/**
 * @author puddi
 */
@Entity
@Getter
@Setter
public class OAuthUser {

    @Id
    @Column(length = 36)
    private String id;

    @Column(nullable = false, length = 256)
    private String issuer;

    @Column(nullable = false, length = 256)
    private String subject;

    @ManyToOne
    private User user;

    @PrePersist
    void setId() {
        if (Objects.isNull(id)) {
            id = UUID.randomUUID().toString();
        }
    }

}
