package cn.geminis.resources.core.entity;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.HashSet;
import java.util.Set;

/**
 * @author puddi
 */
@Entity
@Getter
@Setter
public class Function {

    @Id
    @Column(length = 32)
    private String id;

    @Column(nullable = false, length = 32)
    private String name;

    @ManyToMany(cascade = {CascadeType.MERGE})
    private Set<Function> dependenceFuncs = new HashSet<>();

    @ManyToMany(mappedBy = "functions", cascade = {CascadeType.MERGE})
    private Set<Role> roles = new HashSet<>();

}
