package cn.geminis.resources.core.entity;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Objects;


/**
 * @author Allen
 */
@MappedSuperclass
@Getter
@Setter
public abstract class AbstractEntityProperty<TEntity extends AbstractEntity> {

    @Id
    protected String id;

    @Column(nullable = false, length = 128)
    protected String name;

    @Lob
    protected String stringValue;

    @Column
    protected double numberValue;

    @ManyToOne
    protected TEntity entity;

    @Override
    public boolean equals(Object obj) {
        if (Objects.isNull(obj) || !(obj instanceof AbstractEntityData)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}
