package cn.geminis.resources.core.entity;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

/**
 * @author Allen
 */
@MappedSuperclass
@Getter
@Setter
public abstract class AbstractEntity<TProperty extends AbstractEntityProperty, TData extends AbstractEntityData> {

    @Id
    @Column(length = 36)
    protected String id;

    @Column(nullable = false, length = 128)
    protected String name;

    @OneToMany(mappedBy = "entity", cascade = {CascadeType.PERSIST, CascadeType.REMOVE})
    private Set<TProperty> properties;

    @OneToMany(mappedBy = "entity", cascade = {CascadeType.PERSIST, CascadeType.REMOVE})
    private Set<TData> data;

    @PrePersist
    void setId() {
        if (Objects.isNull(id)) {
            id = UUID.randomUUID().toString();
        }
    }

}
