package cn.geminis.resources.core.client;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * @author Allen
 */
@FeignClient(value = "resources", path = "/users", primary = false)
public interface UserClient {

    /**
     * 获取用户角色
     *
     * @param id 用户ID
     * @return 角色名称
     */
    @GetMapping("/{id}/role/name")
    List<String> userRoleName(@PathVariable("id") String id);

}
