package cn.geminis.resources.core.client;

import cn.geminis.core.data.query.QueryParameters;
import cn.geminis.resources.core.entity.Function;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author Allen
 */
@FeignClient(value = "resources", path = "/functions", primary = false)
public interface FunctionClient {

    /**
     * 保存功能
     *
     * @param function 功能信息
     */
    @PutMapping
    void save(@RequestBody Function function);

    /**
     * 获取功能
     *
     * @param queryParameters 查询参数
     * @return 功能列表
     */
    @PostMapping
    Page<Function> findPage(@RequestBody final QueryParameters queryParameters);

}
