/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.web.logging;

import feign.Logger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Logger.Level.class})
public class FeignLoggingConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FeignLoggingConfiguration.class);
    @Value(value="${geminis.logging.feign.enable:false}")
    private boolean enable;

    @Bean
    Logger.Level feignLoggerLevel() {
        if (this.enable) {
            log.info("\u5f00\u542fFeign\u65e5\u5fd7\u8f93\u51fa");
        }
        return this.enable ? Logger.Level.FULL : Logger.Level.NONE;
    }
}

