/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.web.exception;

import cn.geminis.web.exception.ExceptionResponse;
import java.util.Date;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.HttpStatusCodeException;

@ControllerAdvice
@ConditionalOnClass(value={HttpServlet.class})
public class RestExceptionHandler {
    private static final Logger log = Logger.getLogger(RestExceptionHandler.class.getName());

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ExceptionResponse defaultExceptionHandler(HttpServletRequest req, HttpServletResponse resp, Exception ex) {
        ex.printStackTrace();
        ExceptionResponse response = new ExceptionResponse();
        response.setTimestamp(new Date());
        response.setPath(req.getRequestURI());
        if (ex instanceof HttpStatusCodeException) {
            response.setStatus(((HttpStatusCodeException)ex).getRawStatusCode());
            response.setError(((HttpStatusCodeException)ex).getStatusText());
        } else {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setError(ex.getMessage());
        }
        response.setMessage(ex.getMessage());
        resp.setStatus(response.getStatus());
        return response;
    }
}

