package cn.geminis.web.util;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import java.io.UnsupportedEncodingException;

/**
 * @author puddi
 */
public class ResponseUtils {

    public static <T> ResponseEntity<T> createFileResponse(T content, String fileName, MediaType type) {
        var headers = new HttpHeaders();
        //下载显示的文件名，解决中文名称乱码问题
        String downloadFielName = null;
        try {
            downloadFielName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("文件名编码错误");
        }
        headers.setContentDispositionFormData("attachment", downloadFielName);
        headers.setContentType(type);
        return new ResponseEntity<>(content, headers, HttpStatus.CREATED);
    }
}
