package cn.geminis.web.security;

import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @author puddi
 */
public class LoginUserUtils {

    public static String getLoginUserName() {
        var request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        var encoded = request.getHeader(HttpHeaders.AUTHORIZATION);
        return URLDecoder.decode(encoded, StandardCharsets.UTF_8);
    }

}
