package cn.geminis.web.security;

import feign.RequestInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;

/**
 * @author puddi
 */
@Configuration
public class FeignUserContextConfiguration {
    @Bean
    public RequestInterceptor basicAuthRequestInterceptor() {
        return template -> {
            var userName = LoginUserUtils.getLoginUserName();
            if (!StringUtils.isEmpty(userName)) {
                template.header(HttpHeaders.AUTHORIZATION, userName);
            }
        };
    }
}
