//package cn.geminis.web.logging;
//
//import cn.geminis.core.util.ExceptionUtils;
//import cn.geminis.core.util.ObjectUtils;
//import lombok.extern.slf4j.Slf4j;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.annotation.Around;
//import org.aspectj.lang.annotation.Aspect;
//import org.aspectj.lang.reflect.MethodSignature;
//import org.slf4j.MDC;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.util.StringUtils;
//
//import java.util.Collection;
//import java.util.Objects;
//
///**
// * @author Allen
// */
//@Aspect
//@Configuration
//@Slf4j
//public class LoggingAspect {
//
//    @Around("@annotation(cn.geminis.web.logging.LoggingMethod)")
//    public Object around(ProceedingJoinPoint proceedingJoinPoint) {
//
//        var logContent = new StringBuilder();
//
//        var signature = (MethodSignature) proceedingJoinPoint.getSignature();
//        var method = signature.getMethod();
//        var methodAnnotation = method.getAnnotation(LoggingMethod.class);
//        var parameters = method.getParameters();
//        for (var i = 0; i < parameters.length; i++) {
//            var parameterAnnotation = parameters[i].getDeclaredAnnotation(LoggingParam.class);
//            if (!Objects.isNull(parameterAnnotation)) {
//                logContent
//                        .append(parameterAnnotation.value())
//                        .append("：");
//                var paramValue = proceedingJoinPoint.getArgs()[i];
//
//                if (paramValue instanceof Collection) {
//                    var collectionValue = (Collection) paramValue;
//                    if (collectionValue.size() > 0) {
//                        for (var value : collectionValue) {
//                            logContent.append(StringUtils.isEmpty(parameterAnnotation.field()) ?
//                                    value
//                                    : ObjectUtils.getValue(value, parameterAnnotation.field()));
//                            logContent.append("、");
//                        }
//                        logContent.deleteCharAt(logContent.length() - 1);
//                    }
//                } else {
//                    logContent.append(StringUtils.isEmpty(parameterAnnotation.field()) ?
//                            paramValue
//                            : ObjectUtils.getValue(paramValue, parameterAnnotation.field()));
//                }
//
//                logContent.append("，");
//            }
//        }
//
//        try {
//            MDC.put(LoggingMdcName.RESULT, "成功");
//            return proceedingJoinPoint.proceed();
//        } catch (Throwable e) {
//            MDC.put(LoggingMdcName.RESULT, "失败");
//
//            MDC.put(LoggingMdcName.EXCEPTION, ExceptionUtils.getStackTrace(e));
//
//            logContent
//                    .append("原因：")
//                    .append(ExceptionUtils.getFullMessage(e))
//                    .append("，");
//
//            throw new RuntimeException(methodAnnotation.value() + "失败", e);
//        } finally {
//            logContent
//                    .insert(0, "，")
//                    .insert(0, MDC.get(LoggingMdcName.RESULT))
//                    .insert(0, MDC.get(LoggingMdcName.BUSINESS_NAME));
//            if (!StringUtils.isEmpty(MDC.get(LoggingMdcName.CONTENT_EXT))) {
//                logContent.append(MDC.get(LoggingMdcName.CONTENT_EXT));
//            }
//            logContent.deleteCharAt(logContent.length() - 1);
//            log.info(logContent.toString());
//        }
//    }
//
//}
