package cn.geminis.web.logging;

import feign.Logger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author puddi
 */
@Configuration
@ConditionalOnClass(Logger.Level.class)
@Slf4j
public class FeignLoggingConfiguration {

    @Value("${geminis.logging.feign.enable:false}")
    private boolean enable;

    @Bean
    Logger.Level feignLoggerLevel() {

        if (enable) {
            log.info("开启Feign日志输出");
        }

        return this.enable ? Logger.Level.FULL : Logger.Level.NONE;
    }

}
