package cn.geminis.web.data;

import cn.geminis.core.data.query.FilterGroupCreator;
import cn.geminis.core.data.query.QueryParameters;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Optional;

/**
 * @author Allen
 */
public interface FeignQueryService<T, TThis extends FeignQueryService<T, TThis>> {

    default TThis where(String field, String compareType, Object value) {
        QueryParameters.instance().where(field, compareType, value);
        return (TThis) this;
    }

    default TThis where(String field, Object value) {
        QueryParameters.instance().where(field, value);
        return (TThis) this;
    }

    default TThis whereGroup(String type, FilterGroupCreator creator) {
        QueryParameters.instance().getFilterGroup().setType(type);
        creator.create(QueryParameters.instance().getFilterGroup());
        return (TThis) this;
    }

    default TThis include(String field) {
        QueryParameters.instance().include(field);
        return (TThis) this;
    }

    default TThis orderBy(String field, String order) {
        QueryParameters.instance().orderBy(field, order);
        return (TThis) this;
    }

    default TThis orderBy(String field) {
        QueryParameters.instance().orderBy(field);
        return (TThis) this;
    }

    default TThis pageIndex(int pageIndex) {
        QueryParameters.instance().setPageIndex(pageIndex);
        return (TThis) this;
    }

    default TThis pageSize(int pageSize) {
        QueryParameters.instance().setPageSize(pageSize);
        return (TThis) this;
    }

    default Page<T> findPage() {
        try {
            return this.findPage(QueryParameters.instance());
        } finally {
            QueryParameters.clean();
        }
    }

    default List<T> findList() {
        try {
            return this.findList(QueryParameters.instance());
        } finally {
            QueryParameters.clean();
        }
    }

    default Optional<T> findOne() {
        try {
            return this.findOne(QueryParameters.instance());
        } finally {
            QueryParameters.clean();
        }
    }

    default List<T> findList(@RequestBody final QueryParameters queryParameters) {
        queryParameters.setPageIndex(-1);
        return findPage(queryParameters).getContent();
    }

    /**
     * 查询一个数据
     *
     * @param queryParameters 查询参数
     * @return 查询结果
     */
    default Optional<T> findOne(@RequestBody final QueryParameters queryParameters) {
        queryParameters.setPageSize(1);
        var resultPage = findPage(queryParameters);
        return Optional.ofNullable(resultPage.getContent().size() > 0 ? resultPage.getContent().get(0) : null);
    }


    /**
     * 查询分页数据
     *
     * @param queryParameters 查询参数
     * @return 查询结果
     */
    @PostMapping()
    Page<T> findPage(@RequestBody final QueryParameters queryParameters);
}
