/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.data.jpa.utils;

import cn.geminis.core.data.query.QueryParameters;
import cn.geminis.data.jpa.utils.PredicateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class QueryUtils {
    public static <T> Predicate setQueryParameters(QueryParameters queryParameters, Root<T> root, CriteriaBuilder criteriaBuilder, CriteriaQuery<?> query) {
        ArrayList<From<?, ?>> fetches = new ArrayList();
        if (!query.getResultType().equals(Long.class)) {
            fetches = QueryUtils.setIncludes(queryParameters, root);
        }
        return PredicateUtils.createPredicate(queryParameters.getFilterGroup(), root, criteriaBuilder, fetches);
    }

    private static <T> List<From<?, ?>> setIncludes(QueryParameters queryParameters, Root<T> root) {
        ArrayList result = new ArrayList();
        List includes = queryParameters.getIncludes();
        for (String include : includes) {
            String[] fieldNames = include.split("\\.");
            Fetch fetch = root.fetch(fieldNames[0], JoinType.LEFT);
            result.add((From)fetch);
            for (int i = 1; i < fieldNames.length; ++i) {
                fetch = fetch.fetch(fieldNames[i], JoinType.LEFT);
                result.add((From)fetch);
            }
        }
        return result;
    }

    public static Sort createSort(QueryParameters queryParameters) {
        return Sort.by(queryParameters.getSorts().stream().map(sort -> new Sort.Order(Sort.Direction.valueOf((String)sort.getOrder().toUpperCase()), sort.getField())).collect(Collectors.toList()));
    }

    public static <T> TypedQuery<T> createTypedQuery(EntityManager entityManager, Class<T> clazz, QueryParameters queryParameters) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(clazz);
        Root root = query.from(clazz);
        Predicate predicate = QueryUtils.setQueryParameters(queryParameters, root, criteriaBuilder, query);
        query.where((Expression)predicate);
        Sort sort = QueryUtils.createSort(queryParameters);
        if (sort.isSorted()) {
            query.orderBy(org.springframework.data.jpa.repository.query.QueryUtils.toOrders((Sort)sort, (From)root, (CriteriaBuilder)criteriaBuilder));
        }
        return entityManager.createQuery(query);
    }

    public static Pageable createPageable(QueryParameters queryParameters) {
        if (queryParameters.getPageIndex() < 0) {
            return Pageable.unpaged();
        }
        return PageRequest.of((int)queryParameters.getPageIndex(), (int)queryParameters.getPageSize(), (Sort)QueryUtils.createSort(queryParameters));
    }
}

