/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.data.jpa.utils;

import cn.geminis.core.data.query.Filter;
import cn.geminis.core.data.query.FilterGroup;
import cn.geminis.core.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.util.ObjectUtils;

class PredicateUtils {
    private static final String COMBINE_TYPE_AND = "and";
    private static final String COMBINE_TYPE_OR = "or";

    PredicateUtils() {
    }

    static <T> Predicate createPredicate(FilterGroup filterGroup, Root<T> root, CriteriaBuilder criteriaBuilder, List<From<?, ?>> fetches) {
        List<Predicate> predicates = filterGroup.getChildGroups().stream().map(group -> PredicateUtils.createPredicate(group, root, criteriaBuilder, fetches)).collect(Collectors.toList());
        predicates.addAll(Arrays.asList(PredicateUtils.createPredicates(filterGroup.getFilters(), root, criteriaBuilder, fetches)));
        return PredicateUtils.combine(predicates.toArray(new Predicate[0]), filterGroup.getType(), criteriaBuilder);
    }

    private static <T> Predicate[] createPredicates(List<Filter> filters, Root<T> root, CriteriaBuilder criteriaBuilder, List<From<?, ?>> fetches) {
        return (Predicate[])filters.stream().map(filter -> {
            Object value = filter.getValue();
            if (Objects.isNull(value)) {
                return null;
            }
            String[] fieldNames = filter.getField().split("\\.");
            Root path = root;
            Join joinPath = null;
            Type fieldType = root.getModel().getBindableJavaType();
            for (String fieldName : fieldNames) {
                if ((fieldType = TypeUtils.getFieldType((Class)fieldType, (String)fieldName)) instanceof ParameterizedType && ((ParameterizedType)fieldType).getRawType().equals(Set.class)) {
                    Type fixedType = fieldType = TypeUtils.getGenericInnerType((ParameterizedType)((ParameterizedType)fieldType));
                    Optional<From> fetched = fetches.stream().filter(fetch -> fetch.getModel().getBindableJavaType().equals(fixedType)).findFirst();
                    if (fetched.isPresent()) {
                        path = (Path)fetched.get();
                        continue;
                    }
                    if (path instanceof From) {
                        path = ((From)path).join(fieldName, JoinType.LEFT);
                        continue;
                    }
                    path = ObjectUtils.isEmpty((Object)joinPath) ? root.join(fieldName, JoinType.LEFT) : joinPath.join(fieldName, JoinType.LEFT);
                    continue;
                }
                path = path.get(fieldName);
                if (!((Class)fieldType).isAnnotationPresent(Entity.class)) continue;
                joinPath = ObjectUtils.isEmpty(joinPath) ? root.join(fieldName, JoinType.LEFT) : joinPath.join(fieldName, JoinType.LEFT);
            }
            String compareType = filter.getCompareType();
            return PredicateUtils.createPredicate(criteriaBuilder, compareType, (Path)path, value);
        }).filter(predicate -> !ObjectUtils.isEmpty((Object)predicate)).toArray(Predicate[]::new);
    }

    private static Predicate createPredicate(CriteriaBuilder criteriaBuilder, String compareType, Path path, Object value) {
        Predicate predicate;
        switch (compareType) {
            case "=": {
                predicate = criteriaBuilder.equal((Expression)path, value);
                break;
            }
            case "!=": {
                predicate = criteriaBuilder.notEqual((Expression)path, value);
                break;
            }
            case "<": {
                predicate = criteriaBuilder.lessThan((Expression)path, (Comparable)value);
                break;
            }
            case "<=": {
                predicate = criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)value);
                break;
            }
            case ">": {
                predicate = criteriaBuilder.greaterThan((Expression)path, (Comparable)value);
                break;
            }
            case ">=": {
                predicate = criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)value);
                break;
            }
            case "like": {
                predicate = criteriaBuilder.like((Expression)path, (String)value);
                break;
            }
            case "is not null": {
                predicate = criteriaBuilder.isNotNull((Expression)path);
                break;
            }
            case "is null": {
                predicate = criteriaBuilder.isNull((Expression)path);
                break;
            }
            case "in": {
                if (!(value instanceof Collection)) {
                    throw new InvalidParameterException("In\u67e5\u8be2\u9700\u8981Collection\u7c7b\u578b\u6761\u4ef6");
                }
                Collection collection = (Collection)value;
                predicate = path.in(collection);
                break;
            }
            default: {
                throw new InvalidParameterException("\u4e0d\u652f\u6301\u7684\u6bd4\u8f83\u8868\u8fbe\u5f0f\uff1a" + compareType);
            }
        }
        return predicate;
    }

    private static Predicate combine(Predicate[] predicates, String combineType, CriteriaBuilder criteriaBuilder) {
        if (COMBINE_TYPE_AND.equalsIgnoreCase(combineType)) {
            return criteriaBuilder.and(predicates);
        }
        if (COMBINE_TYPE_OR.equalsIgnoreCase(combineType)) {
            return criteriaBuilder.or(predicates);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301 and \u3001or \u4e4b\u5916\u7684\u5176\u4ed6\u7c7b\u578b\uff1a" + combineType);
    }
}

