/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.data.jpa.config;

import java.util.Locale;
import java.util.Objects;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PrefixPhysicalNamingStrategy
implements PhysicalNamingStrategy {
    @Value(value="${spring.jpa.hibernate.naming.prefix:}")
    private String prefix;

    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return this.apply(name);
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return this.apply(name);
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        if (!Objects.isNull(name)) {
            Object nameText = name.getText();
            nameText = this.prefix + (String)nameText;
            name = new Identifier((String)nameText, false);
        }
        return this.apply(name);
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return this.apply(name);
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return this.apply(name);
    }

    private Identifier apply(Identifier name) {
        if (Objects.isNull(name)) {
            return null;
        }
        StringBuilder builder = new StringBuilder(name.getText().replace('.', '_'));
        for (int i = 1; i < builder.length() - 1; ++i) {
            if (!this.isUnderscoreRequired(builder.charAt(i - 1), builder.charAt(i), builder.charAt(i + 1))) continue;
            builder.insert(i++, '_');
        }
        return this.getIdentifier(builder.toString(), name.isQuoted());
    }

    private Identifier getIdentifier(String name, boolean quoted) {
        name = name.toLowerCase(Locale.ROOT);
        return new Identifier(name, quoted);
    }

    private boolean isUnderscoreRequired(char before, char current, char after) {
        return Character.isLowerCase(before) && Character.isUpperCase(current) && Character.isLowerCase(after);
    }
}

