/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.data.jpa;

import cn.geminis.core.data.query.FilterGroupCreator;
import cn.geminis.core.data.query.QueryParameters;
import cn.geminis.data.jpa.utils.QueryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.util.ProxyUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
public class GeminiRepository {
    @Autowired
    private EntityManager entityManager;

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> Page<T> findPage(Class<T> clazz) {
        try {
            Page<T> page = this.findPage(clazz, QueryParameters.instance());
            return page;
        }
        finally {
            QueryParameters.clean();
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> Page<T> findPage(Class<T> clazz, QueryParameters queryParameters) {
        List content = new ArrayList();
        long count = this.count(clazz, queryParameters);
        Pageable page = QueryUtils.createPageable(queryParameters);
        if (count > 0L) {
            content = queryParameters.getPageIndex() < 0 ? QueryUtils.createTypedQuery(this.entityManager, clazz, queryParameters).getResultList() : QueryUtils.createTypedQuery(this.entityManager, clazz, queryParameters).setFirstResult(queryParameters.getPageSize() * queryParameters.getPageIndex()).setMaxResults(queryParameters.getPageSize()).getResultList();
        }
        return new PageImpl(content, page, count);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> List<T> findList(Class<T> clazz) {
        try {
            List<T> list = this.findList(clazz, QueryParameters.instance());
            return list;
        }
        finally {
            QueryParameters.clean();
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> List<T> findList(Class<T> clazz, QueryParameters queryParameters) {
        return QueryUtils.createTypedQuery(this.entityManager, clazz, queryParameters).getResultList();
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> Optional<T> findOne(Class<T> clazz) {
        try {
            Optional<T> optional = this.findOne(clazz, QueryParameters.instance());
            return optional;
        }
        finally {
            QueryParameters.clean();
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> Optional<T> findOne(Class<T> clazz, QueryParameters queryParameters) {
        try {
            return Optional.of(QueryUtils.createTypedQuery(this.entityManager, clazz, queryParameters).getSingleResult());
        }
        catch (NoResultException var3) {
            return Optional.empty();
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> Optional<T> findById(Class<T> clazz, Object id) {
        Assert.notNull((Object)id, (String)"The given id must not be null!");
        return Optional.ofNullable(this.entityManager.find(clazz, id));
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public <T> Optional<T> getOne(Class<T> clazz, Object id) {
        return Optional.of(this.entityManager.getReference(clazz, id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(Class<?> clazz) {
        try {
            long l = this.count(clazz, QueryParameters.instance());
            return l;
        }
        finally {
            QueryParameters.clean();
        }
    }

    public long count(Class<?> clazz, QueryParameters queryParameters) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
        Root root = query.from(clazz);
        Predicate predicate = QueryUtils.setQueryParameters(queryParameters, root, criteriaBuilder, query);
        query.where((Expression)predicate);
        if (query.isDistinct()) {
            query.select((Selection)criteriaBuilder.countDistinct((Expression)root));
        } else {
            query.select((Selection)criteriaBuilder.count((Expression)root));
        }
        return (Long)this.entityManager.createQuery(query).getSingleResult();
    }

    @Transactional(rollbackFor={Exception.class})
    public <T> T save(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Class type = ProxyUtils.getUserClass(entity);
        JpaEntityInformation entityInformation = JpaEntityInformationSupport.getEntityInformation((Class)type, (EntityManager)this.entityManager);
        if (entityInformation.isNew(entity)) {
            this.entityManager.persist(entity);
            return entity;
        }
        return (T)this.entityManager.merge(entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public <T> void delete(T entity) {
        Object existing;
        Assert.notNull(entity, (String)"Entity must not be null!");
        Class type = ProxyUtils.getUserClass(entity);
        JpaEntityInformation entityInformation = JpaEntityInformationSupport.getEntityInformation((Class)type, (EntityManager)this.entityManager);
        if (!entityInformation.isNew(entity) && (existing = this.entityManager.find(type, entityInformation.getId(entity))) != null) {
            this.entityManager.remove(this.entityManager.contains(entity) ? entity : this.entityManager.merge(entity));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public <T> void deleteById(Class<T> clazz, Object id) {
        Assert.notNull((Object)id, (String)"id must not be null!");
        this.delete(this.findById(clazz, id).orElseThrow(() -> new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", clazz.getName(), id), 1)));
    }

    public GeminiRepository where(String field, String compareType, Object value) {
        QueryParameters.instance().where(field, compareType, value);
        return this;
    }

    public GeminiRepository where(String field, Object value) {
        QueryParameters.instance().where(field, value);
        return this;
    }

    public GeminiRepository whereGroup(String type, FilterGroupCreator creator) {
        QueryParameters.instance().whereGroup(type, creator);
        return this;
    }

    public GeminiRepository include(String field) {
        QueryParameters.instance().include(field);
        return this;
    }

    public GeminiRepository orderBy(String field, String order) {
        QueryParameters.instance().orderBy(field, order);
        return this;
    }

    public GeminiRepository orderBy(String field) {
        QueryParameters.instance().orderBy(field);
        return this;
    }

    public GeminiRepository pageIndex(int pageIndex) {
        QueryParameters.instance().setPageIndex(pageIndex);
        return this;
    }

    public GeminiRepository pageSize(int pageSize) {
        QueryParameters.instance().setPageSize(pageSize);
        return this;
    }
}

