/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.data.jpa;

import cn.geminis.core.data.query.QueryParameters;
import cn.geminis.core.data.query.QueryService;
import cn.geminis.data.jpa.utils.QueryUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.transaction.annotation.Transactional;

@NoRepositoryBean
public interface DynamicRepository<T, TIdType extends Serializable>
extends JpaRepository<T, TIdType>,
JpaSpecificationExecutor<T>,
QueryService<T, DynamicRepository<T, TIdType>> {
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    default public Page<T> findPage(QueryParameters queryParameters) {
        Sort sort = QueryUtils.createSort(queryParameters);
        Pageable pageable = QueryUtils.createPageable(queryParameters);
        if (queryParameters.getPageIndex() < 0) {
            List content = this.findAll((Specification & Serializable)(root, query, criteriaBuilder) -> QueryUtils.setQueryParameters(queryParameters, root, criteriaBuilder, query), sort);
            return new PageImpl(content, pageable, (long)content.size());
        }
        if (queryParameters.getPageSize() == 1) {
            Optional resultOne = this.findOne((Specification & Serializable)(root, query, criteriaBuilder) -> QueryUtils.setQueryParameters(queryParameters, root, criteriaBuilder, query));
            ArrayList content = new ArrayList();
            resultOne.ifPresent(content::add);
            return new PageImpl(content, pageable, 1L);
        }
        return this.findAll((Specification & Serializable)(root, query, criteriaBuilder) -> QueryUtils.setQueryParameters(queryParameters, root, criteriaBuilder, query), pageable);
    }

    default public long countQuery(QueryParameters queryParameters) {
        return this.count((Specification & Serializable)(root, query, criteriaBuilder) -> QueryUtils.setQueryParameters(queryParameters, root, criteriaBuilder, query));
    }
}

