package cn.geminis.core.util;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Objects;

/**
 * @author Allen
 */
public class ObjectUtils {

    public static Object getValue(Object object, String fieldPath) {
        if (Objects.isNull(object)) {
            throw new InvalidParameterException("对象不能为空");
        }
        if (StringUtils.isEmpty(fieldPath)) {
            throw new InvalidParameterException("字段路径不能为空");
        }

        var fieldNames = fieldPath.split("\\.");
        var clazz = object.getClass();
        return getValue(clazz, object, fieldNames, 0);
    }

    public static Object getValue(Class<?> clazz, String fieldPath) {
        if (StringUtils.isEmpty(fieldPath)) {
            throw new InvalidParameterException("字段路径不能为空");
        }

        var fieldNames = fieldPath.split("\\.");
        return getValue(clazz, null, fieldNames, 0);
    }

    private static Object getValue(Class<?> clazz, Object object, String[] fieldNames, int nameIndex) {
        var fieldName = fieldNames[nameIndex];
        var field = TypeUtils.getField(clazz, fieldName);
        if (!field.canAccess(object)) {
            field.setAccessible(true);
        }

        Object fieldValue;
        try {
            fieldValue = field.get(object);
        } catch (Exception e) {
            throw new RuntimeException("获取对象属性错误，属性：" + fieldName, e);
        }

        nameIndex++;
        if (Objects.isNull(fieldValue)) {
            return null;
        } else if (nameIndex < fieldNames.length) {
            return getValue(clazz, fieldValue, fieldNames, nameIndex);
        } else {
            return fieldValue;
        }
    }

    private static void setValue(Class<?> clazz, Object object, String fieldPath, Object value) {
        var fieldNames = fieldPath.split("\\.");
        var getFieldNames = Arrays.copyOfRange(fieldNames, 0, fieldNames.length - 1);
        var fieldParent = object;
        var classParent = clazz;
        if (getFieldNames.length > 0) {
            fieldParent = getValue(clazz, object, getFieldNames, 0);
            if (Objects.isNull(fieldParent)) {
                throw new RuntimeException("父对象为空");
            }
            classParent = fieldParent.getClass();
        }
        var fieldName = fieldNames[fieldNames.length - 1];
        var field = TypeUtils.getField(classParent, fieldName);
        if (!field.canAccess(object)) {
            field.setAccessible(true);
        }
        try {
            field.set(fieldParent, value);
        } catch (IllegalAccessException e) {
            throw new RuntimeException("设置对象属性错误，属性：" + fieldName, e);
        }
    }

    public static void setValue(Object object, String fieldPath, Object value) {
        setValue(object.getClass(), object, fieldPath, value);
    }

    public static void setValue(Class<?> clazz, String fieldPath, Object value) {
        setValue(clazz, null, fieldPath, value);
    }
}
