package cn.geminis.core.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

/**
 * @author Allen
 */
public class ExceptionUtils {

    public static String getStackTrace(Throwable e) {
        try (var sw = new StringWriter();
             var pw = new PrintWriter(sw)) {
            e.printStackTrace(pw);
            return sw.toString();
        } catch (IOException eNew) {
            throw new RuntimeException("获取异常堆栈信息错误", eNew);
        }
    }

    public static String getFullMessage(Throwable e) {
        var stringBuilder = new StringBuilder();
        while (!Objects.isNull(e)) {
            stringBuilder.append(e.getMessage()).append("==>");
            e = e.getCause();
        }
        return stringBuilder.substring(0, stringBuilder.length() - 3);
    }

}
