package cn.geminis.core.reflect;

import java.lang.reflect.Constructor;

/**
 * @author Allen
 */
public class Reflector {

    public static <T extends Object> T reflect(String type) {
        var params = type.split("\\?");
        if (params.length == 1) {
            return reflect(type, null);
        } else {
            return reflect(params[0], params[1]);
        }
    }

    @SuppressWarnings("unchecked")
    public static <T> T reflect(String type, String param) {
        try {
            var c = (Class<T>) Class.forName(type);
            var constructor = (Constructor<T>) c.getConstructors()[0];
            if (param == null || param.isEmpty()) {
                return constructor.newInstance();
            } else {
                String[] params = param.split("\\|");
                return constructor.newInstance((Object[]) params);
            }
        } catch (Exception e) {
            throw new RuntimeException("反射对象错误", e);
        }
    }
}
