package cn.geminis.core.event;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Allen
 */
public class Event<TData, TSender> {

    private List<EventHandler<TData, TSender>> handlers = new ArrayList<>();

    public void add(EventHandler<TData, TSender> handler) {
        handlers.add(handler);
    }

    public void remove(EventHandler<TData, TSender> handler) {
        handlers.remove(handler);
    }

    public void handle(TData data, TSender sender) {
        handlers.forEach(handler -> handler.handle(data, sender));
    }

}
