/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());

    public static String encode(Object obj, String rootName) {
        xStream.alias(rootName, obj.getClass());
        return xStream.toXML(obj);
    }

    public static <T> T decode(String xml) {
        return (T)xStream.fromXML(xml);
    }

    private static Document readDocument(String xml) {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("\u5173\u95ed\u6d41\u9519\u8bef", e);
            }
            catch (SAXException e) {
                throw new RuntimeException("\u89e3\u6790xml\u9519\u8bef", e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("\u6784\u9020DocumentBuilder\u9519\u8bef", e);
            }
        }
        stream.close();
        return document;
    }

    private static String writeDocument(Document document) {
        String string;
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            StreamResult result = new StreamResult(stream);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer trans = factory.newTransformer();
            trans.transform(source, result);
            string = stream.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                throw new RuntimeException("\u751f\u6210XML\u9519\u8bef", e);
            }
        }
        stream.close();
        return string;
    }

    private static Element getElement(Document document, String path) {
        Element element = document.getDocumentElement();
        String[] paths = path.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            NodeList elements = element.getElementsByTagName(paths[i]);
            if (elements.getLength() == 0) {
                throw new RuntimeException("\u672a\u627e\u5230XML\u8282\u70b9\uff1a" + paths[i]);
            }
            element = (Element)elements.item(0);
        }
        return element;
    }

    public static String setAttribute(String xml, String path, String attributeName, String value) {
        Document document = XmlUtils.readDocument(xml);
        Element element = XmlUtils.getElement(document, path);
        element.setAttribute(attributeName, value);
        return XmlUtils.writeDocument(document);
    }

    public static String getAttribute(String xml, String path, String attributeName) {
        Document document = XmlUtils.readDocument(xml);
        Element element = XmlUtils.getElement(document, path);
        return element.getAttribute(attributeName);
    }
}

