/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.util;

import cn.geminis.core.util.StringUtils;
import cn.geminis.core.util.TypeUtils;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.Objects;

public class ObjectUtils {
    public static Object getValue(Object object, String fieldPath) {
        if (Objects.isNull(object)) {
            throw new InvalidParameterException("\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(fieldPath)) {
            throw new InvalidParameterException("\u5b57\u6bb5\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] fieldNames = fieldPath.split("\\.");
        Class<?> clazz = object.getClass();
        return ObjectUtils.getValue(clazz, object, fieldNames, 0);
    }

    public static Object getValue(Class<?> clazz, String fieldPath) {
        if (StringUtils.isEmpty(fieldPath)) {
            throw new InvalidParameterException("\u5b57\u6bb5\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] fieldNames = fieldPath.split("\\.");
        return ObjectUtils.getValue(clazz, null, fieldNames, 0);
    }

    private static Object getValue(Class<?> clazz, Object object, String[] fieldNames, int nameIndex) {
        Object fieldValue;
        String fieldName = fieldNames[nameIndex];
        try {
            Field field = TypeUtils.getField(clazz, fieldName);
            if (!field.canAccess(object)) {
                field.setAccessible(true);
            }
            fieldValue = field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u9519\u8bef\uff0c\u5c5e\u6027\uff1a" + fieldName, e);
        }
        ++nameIndex;
        if (Objects.isNull(fieldValue)) {
            return null;
        }
        if (nameIndex < fieldNames.length) {
            return ObjectUtils.getValue(clazz, fieldValue, fieldNames, nameIndex);
        }
        return fieldValue;
    }
}

