/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

public class ExceptionUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String getStackTrace(Throwable e) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                e.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException eNew) {
            throw new RuntimeException("\u83b7\u53d6\u5f02\u5e38\u5806\u6808\u4fe1\u606f\u9519\u8bef", eNew);
        }
    }

    public static String getFullMessage(Throwable e) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!Objects.isNull(e)) {
            stringBuilder.append(e.getMessage()).append("==>");
            e = e.getCause();
        }
        return stringBuilder.substring(0, stringBuilder.length() - 3);
    }
}

