/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static String toString(Calendar calendar, String format) {
        return DateUtils.toString(calendar.getTime(), format);
    }

    public static String toString(Calendar calendar, String format, Locale locale) {
        return DateUtils.toString(calendar.getTime(), format, locale);
    }

    public static String toString(Date date, String format) {
        return DateUtils.toString(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static String toString(Date date, String format, Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, locale);
        return dateFormat.format(date);
    }

    public static String toString(LocalDateTime date, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return date.format(formatter);
    }

    public static Date parseDate(String value, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u89e3\u6790\u65f6\u95f4\u9519\u8bef", e);
        }
    }

    public static Calendar parseCalendar(String value, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.parseDate(value, format));
        return calendar;
    }

    public static LocalDateTime parseLocalDateTime(String value, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(value, formatter);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static Date toDate(LocalDateTime date) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = date.atZone(zone).toInstant();
        return Date.from(instant);
    }
}

