/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public class ByteUtils {
    private static final int DATA_LENGTH_LONG = 8;
    private static final int DATA_LENGTH_INT = 4;
    private static final int DATA_LENGTH_SHORT = 2;

    public static byte[] duplicate(byte[] data, int length) {
        byte[] result = new byte[length];
        int index = 0;
        do {
            System.arraycopy(data, 0, result, index, index + data.length > length ? length - index : data.length);
        } while ((index += data.length) < length);
        return result;
    }

    public static byte[] resize(byte[] data, int length) {
        return Arrays.copyOf(data, length);
    }

    public static boolean compare(byte[] value1, byte[] value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 != null) {
            return false;
        }
        if (value1 == value2) {
            return true;
        }
        if (value1.length != value2.length) {
            return false;
        }
        for (int i = 0; i < value1.length; ++i) {
            if (value1[i] == value2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] fromUUID(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID toUUID(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    public static String toHex(byte[] data) {
        if (Objects.isNull(data) || data.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int v = data[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] fromHex(String data) {
        if (Objects.isNull(data) || data.length() == 0) {
            return null;
        }
        int len = data.length();
        byte[] b = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            b[i / 2] = (byte)((Character.digit(data.charAt(i), 16) << 4) + Character.digit(data.charAt(i + 1), 16));
        }
        return b;
    }

    public static byte[] sub(byte[] data, int from, int length) {
        return Arrays.copyOfRange(data, from, from + length);
    }

    public static byte[] sub(byte[] data, int from) {
        return ByteUtils.sub(data, from, data.length - from);
    }

    public static byte[] fromLong(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    public static long toLong(byte[] data) {
        return ByteUtils.toLong(data, 0);
    }

    public static long toLong(byte[] data, int index) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return buffer.getLong(index);
    }

    public static byte[] fromInt(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }

    public static int toInt(byte[] data) {
        return ByteUtils.toInt(data, 0);
    }

    public static int toInt(byte[] data, int index) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return buffer.getInt(index);
    }

    public static byte[] fromShort(short value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value);
        return buffer.array();
    }

    public static short toShort(byte[] data) {
        return ByteUtils.toShort(data, 0);
    }

    public static short toShort(byte[] data, int index) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return buffer.getShort(index);
    }

    public static short toShortBE(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.BIG_ENDIAN);
        return buffer.getShort();
    }

    public static byte[] fromShortBE(short value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort(value);
        return buffer.array();
    }

    public static byte[] reverse(byte[] value) {
        byte[] data = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            data[i] = value[value.length - i - 1];
        }
        return data;
    }
}

