/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.data.query;

import cn.geminis.core.data.query.FilterGroupCreator;
import cn.geminis.core.data.query.QueryParameters;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;

public interface QueryService<T, TThis extends QueryService<T, TThis>> {
    default public TThis where(String field, String compareType, Object value) {
        QueryParameters.instance().where(field, compareType, value);
        return (TThis)this;
    }

    default public TThis where(String field, Object value) {
        QueryParameters.instance().where(field, value);
        return (TThis)this;
    }

    default public TThis whereGroup(String type, FilterGroupCreator creator) {
        QueryParameters.instance().getFilterGroup().setType(type);
        creator.create(QueryParameters.instance().getFilterGroup());
        return (TThis)this;
    }

    default public TThis include(String field) {
        QueryParameters.instance().include(field);
        return (TThis)this;
    }

    default public TThis orderBy(String field, String order) {
        QueryParameters.instance().orderBy(field, order);
        return (TThis)this;
    }

    default public TThis orderBy(String field) {
        QueryParameters.instance().orderBy(field);
        return (TThis)this;
    }

    default public TThis pageIndex(int pageIndex) {
        QueryParameters.instance().setPageIndex(pageIndex);
        return (TThis)this;
    }

    default public TThis pageSize(int pageSize) {
        QueryParameters.instance().setPageSize(pageSize);
        return (TThis)this;
    }

    default public Page<T> findPage() {
        try {
            Page<T> page = this.findPage(QueryParameters.instance());
            return page;
        }
        finally {
            QueryParameters.clean();
        }
    }

    public Page<T> findPage(QueryParameters var1);

    default public List<T> findList() {
        try {
            List<T> list = this.findList(QueryParameters.instance());
            return list;
        }
        finally {
            QueryParameters.clean();
        }
    }

    default public List<T> findList(QueryParameters queryParameters) {
        queryParameters.setPageIndex(-1);
        return this.findPage(queryParameters).getContent();
    }

    default public Optional<T> findOne() {
        try {
            Optional<T> optional = this.findOne(QueryParameters.instance());
            return optional;
        }
        finally {
            QueryParameters.clean();
        }
    }

    default public Optional<T> findOne(QueryParameters queryParameters) {
        queryParameters.setPageSize(1);
        Page<T> resultPage = this.findPage(queryParameters);
        return Optional.ofNullable(resultPage.getContent().size() > 0 ? (Object)resultPage.getContent().get(0) : null);
    }

    public long countQuery(QueryParameters var1);

    default public long countQuery() {
        try {
            long l = this.countQuery(QueryParameters.instance());
            return l;
        }
        finally {
            QueryParameters.clean();
        }
    }
}

