/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.data.query;

import cn.geminis.core.data.query.FilterGroup;
import cn.geminis.core.data.query.Sort;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class QueryParameters {
    private int pageIndex;
    private int pageSize = 10;
    private List<Sort> sorts = new LinkedList<Sort>();
    private FilterGroup filterGroup = new FilterGroup();
    private List<String> includes = new LinkedList<String>();
    private static ThreadLocal<QueryParameters> queryParametersThreadLocal = new ThreadLocal();

    public FilterGroup getFilterGroup() {
        return this.filterGroup;
    }

    public QueryParameters where(String field, String compareType, Object value) {
        this.filterGroup.where(field, compareType, value);
        return this;
    }

    public QueryParameters where(String field, Object value) {
        return this.where(field, "=", value);
    }

    public QueryParameters orderBy(String field, String order) {
        Sort sort = new Sort();
        sort.setField(field);
        sort.setOrder(order);
        this.sorts.add(sort);
        return this;
    }

    public QueryParameters orderBy(String field) {
        return this.orderBy(field, "ASC");
    }

    public QueryParameters include(String field) {
        this.includes.add(field);
        return this;
    }

    public static QueryParameters instance() {
        QueryParameters queryParameters = queryParametersThreadLocal.get();
        if (Objects.isNull(queryParameters)) {
            queryParameters = new QueryParameters();
            queryParametersThreadLocal.set(queryParameters);
        }
        return queryParameters;
    }

    public static void clean() {
        queryParametersThreadLocal.remove();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSorts(List<Sort> sorts) {
        this.sorts = sorts;
    }

    public void setFilterGroup(FilterGroup filterGroup) {
        this.filterGroup = filterGroup;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryParameters)) {
            return false;
        }
        QueryParameters other = (QueryParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        List<Sort> this$sorts = this.getSorts();
        List<Sort> other$sorts = other.getSorts();
        if (this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts)) {
            return false;
        }
        FilterGroup this$filterGroup = this.getFilterGroup();
        FilterGroup other$filterGroup = other.getFilterGroup();
        if (this$filterGroup == null ? other$filterGroup != null : !((Object)this$filterGroup).equals(other$filterGroup)) {
            return false;
        }
        List<String> this$includes = this.getIncludes();
        List<String> other$includes = other.getIncludes();
        return !(this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageIndex();
        result = result * 59 + this.getPageSize();
        List<Sort> $sorts = this.getSorts();
        result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
        FilterGroup $filterGroup = this.getFilterGroup();
        result = result * 59 + ($filterGroup == null ? 43 : ((Object)$filterGroup).hashCode());
        List<String> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        return result;
    }

    public String toString() {
        return "QueryParameters(pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", sorts=" + this.getSorts() + ", filterGroup=" + this.getFilterGroup() + ", includes=" + this.getIncludes() + ")";
    }
}

