/*
 * Decompiled with CFR 0.152.
 */
package cn.geminis.core.data.query;

import cn.geminis.core.data.query.Filter;
import cn.geminis.core.data.query.FilterGroupCreator;
import java.util.ArrayList;
import java.util.List;

public class FilterGroup {
    private String type = "and";
    private List<FilterGroup> childGroups = new ArrayList<FilterGroup>();
    private List<Filter> filters = new ArrayList<Filter>();

    public FilterGroup where(String field, String compareType, Object value) {
        Filter filter = new Filter();
        filter.setField(field);
        filter.setCompareType(compareType);
        filter.setValue(value);
        this.filters.add(filter);
        return this;
    }

    public FilterGroup where(String field, Object value) {
        return this.where(field, "=", value);
    }

    public FilterGroup newChildGroup(String type, FilterGroupCreator creator) {
        FilterGroup group = new FilterGroup();
        group.setType(type);
        creator.create(group);
        this.childGroups.add(group);
        return group;
    }

    public String getType() {
        return this.type;
    }

    public List<FilterGroup> getChildGroups() {
        return this.childGroups;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChildGroups(List<FilterGroup> childGroups) {
        this.childGroups = childGroups;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterGroup)) {
            return false;
        }
        FilterGroup other = (FilterGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<FilterGroup> this$childGroups = this.getChildGroups();
        List<FilterGroup> other$childGroups = other.getChildGroups();
        if (this$childGroups == null ? other$childGroups != null : !((Object)this$childGroups).equals(other$childGroups)) {
            return false;
        }
        List<Filter> this$filters = this.getFilters();
        List<Filter> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<FilterGroup> $childGroups = this.getChildGroups();
        result = result * 59 + ($childGroups == null ? 43 : ((Object)$childGroups).hashCode());
        List<Filter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "FilterGroup(type=" + this.getType() + ", childGroups=" + this.getChildGroups() + ", filters=" + this.getFilters() + ")";
    }
}

