package cn.geminis.core.util;

import cn.geminis.core.reflect.ParameterizedTypeImpl;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

/**
 * @author Allen
 */
public class TypeUtils {

    public static Field getField(Class<?> clazz, String fieldName) {
        var originalClass = clazz;
        while (null != clazz) {
            var fields = clazz.getDeclaredFields();
            var found = Arrays.stream(fields).filter(f -> f.getName().equals(fieldName)).findAny();
            if (found.isPresent()) {
                return found.get();
            } else {
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException("类型不包含字段，Class：" + originalClass.getName() + "，Field：" + fieldName);
    }

    public static Type getFieldType(Class<?> clazz, String fieldName) {
        var field = getField(clazz, fieldName);
        return field.getGenericType();
    }

    public static ParameterizedType createGenericType(Class<?> componentType, Class<?>... clazz) {
        return new ParameterizedTypeImpl(componentType, clazz, null);
    }

    public static Type getGenericInnerType(ParameterizedType type) {
        return getGenericInnerType(type, 0);
    }

    public static Type getGenericInnerType(ParameterizedType type, int index) {
        return type.getActualTypeArguments()[index];
    }

}
