package cn.geminis.core.util;

import java.util.Objects;

/**
 * @author Allen
 */
public class StringUtils {

    public static String trim(String value, String trimValue) {
        var stringBuilder = new StringBuilder(value);
        trim(stringBuilder, trimValue);
        return stringBuilder.toString();
    }

    public static void trim(StringBuilder stringBuilder, String trimValue) {
        var lastIndex = stringBuilder.length() - trimValue.length();

        while (stringBuilder.lastIndexOf(trimValue) == lastIndex) {
            stringBuilder.delete(lastIndex, stringBuilder.length());
            lastIndex = stringBuilder.length() - trimValue.length();
        }

        while (stringBuilder.indexOf(trimValue) == 0) {
            stringBuilder.delete(0, trimValue.length());
        }
    }

    public static boolean isEmpty(String value) {
        return Objects.isNull(value) || value.length() == 0;
    }

    public static String padLeft(String value, int length, char padValue) {
        var stringBuilder = new StringBuilder();
        stringBuilder.append(value);
        while (stringBuilder.length() < length) {
            stringBuilder.insert(0, padValue);
        }
        return stringBuilder.toString();
    }

    public static boolean equals(String value1, String value2) {
        if (Objects.isNull(value1)) {
            return Objects.isNull(value2);
        } else {
            return value1.equals(value2);
        }
    }

}
