package cn.geminis.core.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;

/**
 * @author puddi
 */
public class PasswordUtils {

    public static String createSalt() {
        var random = new Random();
        var salt = new byte[16];
        random.nextBytes(salt);
        return Base64.getEncoder().encodeToString(salt);
    }

    public static String addSalt(String password, String salt) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("密码加盐错误", e);
        }
        md.update((password + salt).getBytes(StandardCharsets.US_ASCII));
        var digest = md.digest();
        return Base64.getEncoder().encodeToString(digest);
    }

}
