package cn.geminis.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

/**
 * @author Allen
 */
public class JsonUtils {

    private static ObjectMapper mapper;

    static {
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static String encode(Object object) {
        try {
            return mapper.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            throw new RuntimeException("序列化JSON对象错误", e);
        }
    }

    public static <T> T decode(String json, Class<T> aClass) {
        try {
            return mapper.readValue(json, aClass);
        } catch (IOException e) {
            throw new RuntimeException("反序列化JSON对象错误", e);
        }
    }

}
