package cn.geminis.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * @author Allen
 */
public class DateUtils {

    public static String toString(Calendar calendar, String format) {
        return toString(calendar.getTime(), format);
    }

    public static String toString(Calendar calendar, String format, Locale locale) {
        return toString(calendar.getTime(), format, locale);
    }

    public static String toString(Date date, String format) {
        return toString(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static String toString(Date date, String format, Locale locale) {
        var dateFormat = new SimpleDateFormat(format, locale);
        return dateFormat.format(date);
    }

    public static String toString(LocalDateTime date, String format) {
        var formatter = DateTimeFormatter.ofPattern(format);
        return date.format(formatter);
    }

    public static Date parseDate(String value, String format) {
        var dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(value);
        } catch (ParseException e) {
            throw new RuntimeException("解析时间错误", e);
        }
    }

    public static Calendar parseCalendar(String value, String format) {
        var calendar = Calendar.getInstance();
        calendar.setTime(parseDate(value, format));
        return calendar;
    }

    public static LocalDateTime parseLocalDateTime(String value, String format) {
        var formatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(value, formatter);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        var instant = date.toInstant();
        var zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static Date toDate(LocalDateTime date) {
        var zone = ZoneId.systemDefault();
        var instant = date.atZone(zone).toInstant();
        return Date.from(instant);
    }
}
