package cn.geminis.core.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * @author Allen
 */
public class XmlUtils {

    public static byte[] encode(Object object) {
        try (var stream = new ByteArrayOutputStream()) {
            var encoder = new XMLEncoder(stream);
            encoder.writeObject(object);
            return stream.toByteArray();
        } catch (IOException e) {
            throw new RuntimeException("关闭输出流错误", e);
        }
    }

    @SuppressWarnings("unchecked")
    public static <T> T decode(byte[] xml) {
        try (var stream = new ByteArrayInputStream(xml)) {
            var decoder = new XMLDecoder(stream);
            var obj = decoder.readObject();
            return (T) obj;
        } catch (IOException e) {
            throw new RuntimeException("关闭输入流错误", e);
        }
    }

}
