package cn.geminis.core.util;

import java.security.InvalidParameterException;
import java.util.Objects;

/**
 * @author Allen
 */
public class ObjectUtils {

    public static Object getValue(Object object, String fieldPath) {
        if (Objects.isNull(object)) {
            throw new InvalidParameterException("对象不能为空");
        }
        if (StringUtils.isEmpty(fieldPath)) {
            throw new InvalidParameterException("字段路径不能为空");
        }

        var fieldNames = fieldPath.split("\\.");
        var clazz = object.getClass();
        return getValue(clazz, object, fieldNames, 0);
    }

    public static Object getValue(Class<?> clazz, String fieldPath) {
        if (StringUtils.isEmpty(fieldPath)) {
            throw new InvalidParameterException("字段路径不能为空");
        }

        var fieldNames = fieldPath.split("\\.");
        return getValue(clazz, null, fieldNames, 0);
    }

    private static Object getValue(Class<?> clazz, Object object, String[] fieldNames, int nameIndex) {

        var fieldName = fieldNames[nameIndex];
        Object fieldValue;
        try {
            var field = TypeUtils.getField(clazz, fieldName);
            if (!field.canAccess(object)) {
                field.setAccessible(true);
            }
            fieldValue = field.get(object);
        } catch (Exception e) {
            throw new RuntimeException("获取对象属性错误，属性：" + fieldName, e);
        }
        nameIndex++;
        if (Objects.isNull(fieldValue)) {
            return null;
        } else if (nameIndex < fieldNames.length) {
            return getValue(clazz, fieldValue, fieldNames, nameIndex);
        } else {
            return fieldValue;
        }
    }

}
